package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelsModeratedByAppInstanceUserResponse(
    channels: Optional[
      Iterable[zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse = {
    import ListChannelsModeratedByAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object ListChannelsModeratedByAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse =
      zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Optional[List[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse
  ) extends zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly {
    override val channels: Optional[List[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse
  ): zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
