package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{NextToken, MaxResults, ChimeArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelsRequest(
    appInstanceArn: ChimeArn,
    privacy: Optional[zio.aws.chime.model.ChannelPrivacy] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelsRequest = {
    import ListChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelsRequest.ReadOnly =
    zio.aws.chime.model.ListChannelsRequest.wrap(buildAwsValue())
}
object ListChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelsRequest =
      zio.aws.chime.model.ListChannelsRequest(
        appInstanceArn,
        privacy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer.map(value => value)
      )
    def appInstanceArn: ChimeArn
    def privacy: Optional[zio.aws.chime.model.ChannelPrivacy]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def chimeBearer: Optional[ChimeArn]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getPrivacy: ZIO[Any, AwsError, zio.aws.chime.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsRequest
  ) extends zio.aws.chime.model.ListChannelsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val privacy: Optional[zio.aws.chime.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value => zio.aws.chime.model.ChannelPrivacy.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsRequest
  ): zio.aws.chime.model.ListChannelsRequest.ReadOnly = new Wrapper(impl)
}
