package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    channels: Optional[Iterable[zio.aws.chime.model.ChannelSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListChannelsResponse.ReadOnly =
    zio.aws.chime.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListChannelsResponse =
      zio.aws.chime.model.ListChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Optional[List[zio.aws.chime.model.ChannelSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.chime.model.ChannelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsResponse
  ) extends zio.aws.chime.model.ListChannelsResponse.ReadOnly {
    override val channels
        : Optional[List[zio.aws.chime.model.ChannelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.ChannelSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListChannelsResponse
  ): zio.aws.chime.model.ListChannelsResponse.ReadOnly = new Wrapper(impl)
}
