package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMediaCapturePipelinesResponse(
    mediaCapturePipelines: Optional[
      Iterable[zio.aws.chime.model.MediaCapturePipeline]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse = {
    import ListMediaCapturePipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse
      .builder()
      .optionallyWith(
        mediaCapturePipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaCapturePipelines)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly =
    zio.aws.chime.model.ListMediaCapturePipelinesResponse.wrap(buildAwsValue())
}
object ListMediaCapturePipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListMediaCapturePipelinesResponse =
      zio.aws.chime.model.ListMediaCapturePipelinesResponse(
        mediaCapturePipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def mediaCapturePipelines
        : Optional[List[zio.aws.chime.model.MediaCapturePipeline.ReadOnly]]
    def nextToken: Optional[String]
    def getMediaCapturePipelines: ZIO[Any, AwsError, List[
      zio.aws.chime.model.MediaCapturePipeline.ReadOnly
    ]] =
      AwsError.unwrapOptionField("mediaCapturePipelines", mediaCapturePipelines)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse
  ) extends zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly {
    override val mediaCapturePipelines
        : Optional[List[zio.aws.chime.model.MediaCapturePipeline.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaCapturePipelines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.MediaCapturePipeline.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse
  ): zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
