package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListMeetingTagsRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest = {
    import ListMeetingTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListMeetingTagsRequest.ReadOnly =
    zio.aws.chime.model.ListMeetingTagsRequest.wrap(buildAwsValue())
}
object ListMeetingTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListMeetingTagsRequest =
      zio.aws.chime.model.ListMeetingTagsRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest
  ) extends zio.aws.chime.model.ListMeetingTagsRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest
  ): zio.aws.chime.model.ListMeetingTagsRequest.ReadOnly = new Wrapper(impl)
}
