package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.ResultMax
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMeetingsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListMeetingsRequest = {
    import ListMeetingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListMeetingsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListMeetingsRequest.ReadOnly =
    zio.aws.chime.model.ListMeetingsRequest.wrap(buildAwsValue())
}
object ListMeetingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListMeetingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListMeetingsRequest =
      zio.aws.chime.model.ListMeetingsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingsRequest
  ) extends zio.aws.chime.model.ListMeetingsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingsRequest
  ): zio.aws.chime.model.ListMeetingsRequest.ReadOnly = new Wrapper(impl)
}
