package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMeetingsResponse(
    meetings: Optional[Iterable[zio.aws.chime.model.Meeting]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListMeetingsResponse = {
    import ListMeetingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListMeetingsResponse
      .builder()
      .optionallyWith(
        meetings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.meetings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListMeetingsResponse.ReadOnly =
    zio.aws.chime.model.ListMeetingsResponse.wrap(buildAwsValue())
}
object ListMeetingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListMeetingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListMeetingsResponse =
      zio.aws.chime.model.ListMeetingsResponse(
        meetings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def meetings: Optional[List[zio.aws.chime.model.Meeting.ReadOnly]]
    def nextToken: Optional[String]
    def getMeetings
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Meeting.ReadOnly]] =
      AwsError.unwrapOptionField("meetings", meetings)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingsResponse
  ) extends zio.aws.chime.model.ListMeetingsResponse.ReadOnly {
    override val meetings
        : Optional[List[zio.aws.chime.model.Meeting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meetings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Meeting.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListMeetingsResponse
  ): zio.aws.chime.model.ListMeetingsResponse.ReadOnly = new Wrapper(impl)
}
