package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPhoneNumberOrdersResponse(
    phoneNumberOrders: Optional[
      Iterable[zio.aws.chime.model.PhoneNumberOrder]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse = {
    import ListPhoneNumberOrdersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse
      .builder()
      .optionallyWith(
        phoneNumberOrders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberOrders)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly =
    zio.aws.chime.model.ListPhoneNumberOrdersResponse.wrap(buildAwsValue())
}
object ListPhoneNumberOrdersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListPhoneNumberOrdersResponse =
      zio.aws.chime.model.ListPhoneNumberOrdersResponse(
        phoneNumberOrders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def phoneNumberOrders
        : Optional[List[zio.aws.chime.model.PhoneNumberOrder.ReadOnly]]
    def nextToken: Optional[String]
    def getPhoneNumberOrders: ZIO[Any, AwsError, List[
      zio.aws.chime.model.PhoneNumberOrder.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberOrders", phoneNumberOrders)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse
  ) extends zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly {
    override val phoneNumberOrders
        : Optional[List[zio.aws.chime.model.PhoneNumberOrder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.PhoneNumberOrder.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse
  ): zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly = new Wrapper(
    impl
  )
}
