package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  ResultMax,
  NextTokenString,
  NonEmptyString128
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProxySessionsRequest(
    voiceConnectorId: NonEmptyString128,
    status: Optional[zio.aws.chime.model.ProxySessionStatus] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListProxySessionsRequest = {
    import ListProxySessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListProxySessionsRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListProxySessionsRequest.ReadOnly =
    zio.aws.chime.model.ListProxySessionsRequest.wrap(buildAwsValue())
}
object ListProxySessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListProxySessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListProxySessionsRequest =
      zio.aws.chime.model.ListProxySessionsRequest(
        voiceConnectorId,
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def voiceConnectorId: NonEmptyString128
    def status: Optional[zio.aws.chime.model.ProxySessionStatus]
    def nextToken: Optional[NextTokenString]
    def maxResults: Optional[ResultMax]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getStatus: ZIO[Any, AwsError, zio.aws.chime.model.ProxySessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListProxySessionsRequest
  ) extends zio.aws.chime.model.ListProxySessionsRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.voiceConnectorId())
    override val status: Optional[zio.aws.chime.model.ProxySessionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.ProxySessionStatus.wrap(value))
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextTokenString(value))
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListProxySessionsRequest
  ): zio.aws.chime.model.ListProxySessionsRequest.ReadOnly = new Wrapper(impl)
}
