package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{ResultMax, NonEmptyString}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRoomMembershipsRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString,
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest = {
    import ListRoomMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListRoomMembershipsRequest.ReadOnly =
    zio.aws.chime.model.ListRoomMembershipsRequest.wrap(buildAwsValue())
}
object ListRoomMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListRoomMembershipsRequest =
      zio.aws.chime.model.ListRoomMembershipsRequest(
        accountId,
        roomId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[String]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest
  ) extends zio.aws.chime.model.ListRoomMembershipsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest
  ): zio.aws.chime.model.ListRoomMembershipsRequest.ReadOnly = new Wrapper(impl)
}
