package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRoomMembershipsResponse(
    roomMemberships: Optional[Iterable[zio.aws.chime.model.RoomMembership]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse = {
    import ListRoomMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse
      .builder()
      .optionallyWith(
        roomMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roomMemberships)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly =
    zio.aws.chime.model.ListRoomMembershipsResponse.wrap(buildAwsValue())
}
object ListRoomMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListRoomMembershipsResponse =
      zio.aws.chime.model.ListRoomMembershipsResponse(
        roomMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def roomMemberships
        : Optional[List[zio.aws.chime.model.RoomMembership.ReadOnly]]
    def nextToken: Optional[String]
    def getRoomMemberships: ZIO[Any, AwsError, List[
      zio.aws.chime.model.RoomMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("roomMemberships", roomMemberships)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse
  ) extends zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly {
    override val roomMemberships
        : Optional[List[zio.aws.chime.model.RoomMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.RoomMembership.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse
  ): zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly = new Wrapper(
    impl
  )
}
