package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{ResultMax, NonEmptyString}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRoomsRequest(
    accountId: NonEmptyString,
    memberId: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListRoomsRequest = {
    import ListRoomsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListRoomsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .optionallyWith(memberId.map(value => value: java.lang.String))(
        _.memberId
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListRoomsRequest.ReadOnly =
    zio.aws.chime.model.ListRoomsRequest.wrap(buildAwsValue())
}
object ListRoomsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListRoomsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListRoomsRequest =
      zio.aws.chime.model.ListRoomsRequest(
        accountId,
        memberId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountId: NonEmptyString
    def memberId: Optional[String]
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[String]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getMemberId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListRoomsRequest
  ) extends zio.aws.chime.model.ListRoomsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val memberId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListRoomsRequest
  ): zio.aws.chime.model.ListRoomsRequest.ReadOnly = new Wrapper(impl)
}
