package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRoomsResponse(
    rooms: Optional[Iterable[zio.aws.chime.model.Room]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListRoomsResponse = {
    import ListRoomsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListRoomsResponse
      .builder()
      .optionallyWith(
        rooms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rooms)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListRoomsResponse.ReadOnly =
    zio.aws.chime.model.ListRoomsResponse.wrap(buildAwsValue())
}
object ListRoomsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListRoomsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListRoomsResponse =
      zio.aws.chime.model.ListRoomsResponse(
        rooms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def rooms: Optional[List[zio.aws.chime.model.Room.ReadOnly]]
    def nextToken: Optional[String]
    def getRooms: ZIO[Any, AwsError, List[zio.aws.chime.model.Room.ReadOnly]] =
      AwsError.unwrapOptionField("rooms", rooms)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListRoomsResponse
  ) extends zio.aws.chime.model.ListRoomsResponse.ReadOnly {
    override val rooms: Optional[List[zio.aws.chime.model.Room.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rooms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Room.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListRoomsResponse
  ): zio.aws.chime.model.ListRoomsResponse.ReadOnly = new Wrapper(impl)
}
