package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{NextTokenString, ResultMax}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSipMediaApplicationsRequest(
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest = {
    import ListSipMediaApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListSipMediaApplicationsRequest.ReadOnly =
    zio.aws.chime.model.ListSipMediaApplicationsRequest.wrap(buildAwsValue())
}
object ListSipMediaApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListSipMediaApplicationsRequest =
      zio.aws.chime.model.ListSipMediaApplicationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[NextTokenString]
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest
  ) extends zio.aws.chime.model.ListSipMediaApplicationsRequest.ReadOnly {
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest
  ): zio.aws.chime.model.ListSipMediaApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
