package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextTokenString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSipMediaApplicationsResponse(
    sipMediaApplications: Optional[
      Iterable[zio.aws.chime.model.SipMediaApplication]
    ] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse = {
    import ListSipMediaApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse
      .builder()
      .optionallyWith(
        sipMediaApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipMediaApplications)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly =
    zio.aws.chime.model.ListSipMediaApplicationsResponse.wrap(buildAwsValue())
}
object ListSipMediaApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListSipMediaApplicationsResponse =
      zio.aws.chime.model.ListSipMediaApplicationsResponse(
        sipMediaApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sipMediaApplications
        : Optional[List[zio.aws.chime.model.SipMediaApplication.ReadOnly]]
    def nextToken: Optional[NextTokenString]
    def getSipMediaApplications: ZIO[Any, AwsError, List[
      zio.aws.chime.model.SipMediaApplication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sipMediaApplications", sipMediaApplications)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse
  ) extends zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly {
    override val sipMediaApplications
        : Optional[List[zio.aws.chime.model.SipMediaApplication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.SipMediaApplication.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse
  ): zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
