package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  NextTokenString,
  ResultMax,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSipRulesRequest(
    sipMediaApplicationId: Optional[NonEmptyString] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListSipRulesRequest = {
    import ListSipRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListSipRulesRequest
      .builder()
      .optionallyWith(
        sipMediaApplicationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sipMediaApplicationId)
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListSipRulesRequest.ReadOnly =
    zio.aws.chime.model.ListSipRulesRequest.wrap(buildAwsValue())
}
object ListSipRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListSipRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListSipRulesRequest =
      zio.aws.chime.model.ListSipRulesRequest(
        sipMediaApplicationId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sipMediaApplicationId: Optional[NonEmptyString]
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[NextTokenString]
    def getSipMediaApplicationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sipMediaApplicationId", sipMediaApplicationId)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListSipRulesRequest
  ) extends zio.aws.chime.model.ListSipRulesRequest.ReadOnly {
    override val sipMediaApplicationId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplicationId())
        .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListSipRulesRequest
  ): zio.aws.chime.model.ListSipRulesRequest.ReadOnly = new Wrapper(impl)
}
