package zio.aws.chime.model
import zio.aws.chime.model.primitives.NextTokenString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSipRulesResponse(
    sipRules: Optional[Iterable[zio.aws.chime.model.SipRule]] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListSipRulesResponse = {
    import ListSipRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListSipRulesResponse
      .builder()
      .optionallyWith(
        sipRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipRules)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListSipRulesResponse.ReadOnly =
    zio.aws.chime.model.ListSipRulesResponse.wrap(buildAwsValue())
}
object ListSipRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListSipRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListSipRulesResponse =
      zio.aws.chime.model.ListSipRulesResponse(
        sipRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sipRules: Optional[List[zio.aws.chime.model.SipRule.ReadOnly]]
    def nextToken: Optional[NextTokenString]
    def getSipRules
        : ZIO[Any, AwsError, List[zio.aws.chime.model.SipRule.ReadOnly]] =
      AwsError.unwrapOptionField("sipRules", sipRules)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListSipRulesResponse
  ) extends zio.aws.chime.model.ListSipRulesResponse.ReadOnly {
    override val sipRules
        : Optional[List[zio.aws.chime.model.SipRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.SipRule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chime.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListSipRulesResponse
  ): zio.aws.chime.model.ListSipRulesResponse.ReadOnly = new Wrapper(impl)
}
