package zio.aws.chime.model
import zio.aws.chime.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.chime.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListTagsForResourceRequest =
      zio.aws.chime.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: Arn
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest
  ) extends zio.aws.chime.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.chime.model.primitives.Arn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest
  ): zio.aws.chime.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
