package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  ProfileServiceMaxResults,
  EmailAddress,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUsersRequest(
    accountId: NonEmptyString,
    userEmail: Optional[EmailAddress] = Optional.Absent,
    userType: Optional[zio.aws.chime.model.UserType] = Optional.Absent,
    maxResults: Optional[ProfileServiceMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListUsersRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .optionallyWith(
        userEmail.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.userEmail)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .optionallyWith(
        maxResults.map(value => ProfileServiceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListUsersRequest.ReadOnly =
    zio.aws.chime.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListUsersRequest =
      zio.aws.chime.model.ListUsersRequest(
        accountId,
        userEmail.map(value => value),
        userType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountId: NonEmptyString
    def userEmail: Optional[EmailAddress]
    def userType: Optional[zio.aws.chime.model.UserType]
    def maxResults: Optional[ProfileServiceMaxResults]
    def nextToken: Optional[String]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserEmail: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("userEmail", userEmail)
    def getUserType: ZIO[Any, AwsError, zio.aws.chime.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
    def getMaxResults: ZIO[Any, AwsError, ProfileServiceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListUsersRequest
  ) extends zio.aws.chime.model.ListUsersRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userEmail: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.userEmail())
      .map(value => zio.aws.chime.model.primitives.EmailAddress(value))
    override val userType: Optional[zio.aws.chime.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.chime.model.UserType.wrap(value))
    override val maxResults: Optional[ProfileServiceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.chime.model.primitives.ProfileServiceMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListUsersRequest
  ): zio.aws.chime.model.ListUsersRequest.ReadOnly = new Wrapper(impl)
}
