package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListUsersResponse(
    users: Optional[Iterable[zio.aws.chime.model.User]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListUsersResponse.ReadOnly =
    zio.aws.chime.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListUsersResponse =
      zio.aws.chime.model.ListUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[List[zio.aws.chime.model.User.ReadOnly]]
    def nextToken: Optional[String]
    def getUsers: ZIO[Any, AwsError, List[zio.aws.chime.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListUsersResponse
  ) extends zio.aws.chime.model.ListUsersResponse.ReadOnly {
    override val users: Optional[List[zio.aws.chime.model.User.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.User.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListUsersResponse
  ): zio.aws.chime.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
