package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorGroupsResponse(
    voiceConnectorGroups: Optional[
      Iterable[zio.aws.chime.model.VoiceConnectorGroup]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse = {
    import ListVoiceConnectorGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse
      .builder()
      .optionallyWith(
        voiceConnectorGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectorGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly =
    zio.aws.chime.model.ListVoiceConnectorGroupsResponse.wrap(buildAwsValue())
}
object ListVoiceConnectorGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListVoiceConnectorGroupsResponse =
      zio.aws.chime.model.ListVoiceConnectorGroupsResponse(
        voiceConnectorGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voiceConnectorGroups
        : Optional[List[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly]]
    def nextToken: Optional[String]
    def getVoiceConnectorGroups: ZIO[Any, AwsError, List[
      zio.aws.chime.model.VoiceConnectorGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("voiceConnectorGroups", voiceConnectorGroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse
  ) extends zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly {
    override val voiceConnectorGroups
        : Optional[List[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.VoiceConnectorGroup.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse
  ): zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
