package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorTerminationCredentialsRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest = {
    import ListVoiceConnectorTerminationCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsRequest
      .wrap(buildAwsValue())
}
object ListVoiceConnectorTerminationCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsRequest =
      zio.aws.chime.model
        .ListVoiceConnectorTerminationCredentialsRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest
  ) extends zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest
  ): zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
