package zio.aws.chime.model
import zio.aws.chime.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorTerminationCredentialsResponse(
    usernames: Optional[Iterable[SensitiveString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse = {
    import ListVoiceConnectorTerminationCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse
      .builder()
      .optionallyWith(
        usernames.map(value =>
          value.map { item =>
            SensitiveString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usernames)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly =
    zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse
      .wrap(buildAwsValue())
}
object ListVoiceConnectorTerminationCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse =
      zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse(
        usernames.map(value => value)
      )
    def usernames: Optional[List[SensitiveString]]
    def getUsernames: ZIO[Any, AwsError, List[SensitiveString]] =
      AwsError.unwrapOptionField("usernames", usernames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse
  ) extends zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly {
    override val usernames: Optional[List[SensitiveString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usernames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.primitives.SensitiveString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse
  ): zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
