package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.ResultMax
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest = {
    import ListVoiceConnectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ListVoiceConnectorsRequest.ReadOnly =
    zio.aws.chime.model.ListVoiceConnectorsRequest.wrap(buildAwsValue())
}
object ListVoiceConnectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ListVoiceConnectorsRequest =
      zio.aws.chime.model.ListVoiceConnectorsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest
  ) extends zio.aws.chime.model.ListVoiceConnectorsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chime.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest
  ): zio.aws.chime.model.ListVoiceConnectorsRequest.ReadOnly = new Wrapper(impl)
}
