package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    enableSIPLogs: Optional[Boolean] = Optional.Absent,
    enableMediaMetricLogs: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.LoggingConfiguration
      .builder()
      .optionallyWith(enableSIPLogs.map(value => value: java.lang.Boolean))(
        _.enableSIPLogs
      )
      .optionallyWith(
        enableMediaMetricLogs.map(value => value: java.lang.Boolean)
      )(_.enableMediaMetricLogs)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.LoggingConfiguration.ReadOnly =
    zio.aws.chime.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.LoggingConfiguration =
      zio.aws.chime.model.LoggingConfiguration(
        enableSIPLogs.map(value => value),
        enableMediaMetricLogs.map(value => value)
      )
    def enableSIPLogs: Optional[Boolean]
    def enableMediaMetricLogs: Optional[Boolean]
    def getEnableSIPLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableSIPLogs", enableSIPLogs)
    def getEnableMediaMetricLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMediaMetricLogs", enableMediaMetricLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.LoggingConfiguration
  ) extends zio.aws.chime.model.LoggingConfiguration.ReadOnly {
    override val enableSIPLogs: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableSIPLogs())
      .map(value => value: Boolean)
    override val enableMediaMetricLogs: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableMediaMetricLogs())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.LoggingConfiguration
  ): zio.aws.chime.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
