package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LogoutUserRequest(
    accountId: NonEmptyString,
    userId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.LogoutUserRequest = {
    import LogoutUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.LogoutUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userId(NonEmptyString.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.LogoutUserRequest.ReadOnly =
    zio.aws.chime.model.LogoutUserRequest.wrap(buildAwsValue())
}
object LogoutUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.LogoutUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.LogoutUserRequest =
      zio.aws.chime.model.LogoutUserRequest(accountId, userId)
    def accountId: NonEmptyString
    def userId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.LogoutUserRequest
  ) extends zio.aws.chime.model.LogoutUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.LogoutUserRequest
  ): zio.aws.chime.model.LogoutUserRequest.ReadOnly = new Wrapper(impl)
}
