package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Iso8601Timestamp, Arn, GuidString}
import scala.jdk.CollectionConverters._
final case class MediaCapturePipeline(
    mediaPipelineId: Optional[GuidString] = Optional.Absent,
    sourceType: Optional[zio.aws.chime.model.MediaPipelineSourceType] =
      Optional.Absent,
    sourceArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.chime.model.MediaPipelineStatus] = Optional.Absent,
    sinkType: Optional[zio.aws.chime.model.MediaPipelineSinkType] =
      Optional.Absent,
    sinkArn: Optional[Arn] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    chimeSdkMeetingConfiguration: Optional[
      zio.aws.chime.model.ChimeSdkMeetingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.MediaCapturePipeline = {
    import MediaCapturePipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.MediaCapturePipeline
      .builder()
      .optionallyWith(
        mediaPipelineId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.mediaPipelineId)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(
        sourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sinkType.map(value => value.unwrap))(_.sinkType)
      .optionallyWith(
        sinkArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sinkArn)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        chimeSdkMeetingConfiguration.map(value => value.buildAwsValue())
      )(_.chimeSdkMeetingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.MediaCapturePipeline.ReadOnly =
    zio.aws.chime.model.MediaCapturePipeline.wrap(buildAwsValue())
}
object MediaCapturePipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.MediaCapturePipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.MediaCapturePipeline =
      zio.aws.chime.model.MediaCapturePipeline(
        mediaPipelineId.map(value => value),
        sourceType.map(value => value),
        sourceArn.map(value => value),
        status.map(value => value),
        sinkType.map(value => value),
        sinkArn.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        chimeSdkMeetingConfiguration.map(value => value.asEditable)
      )
    def mediaPipelineId: Optional[GuidString]
    def sourceType: Optional[zio.aws.chime.model.MediaPipelineSourceType]
    def sourceArn: Optional[Arn]
    def status: Optional[zio.aws.chime.model.MediaPipelineStatus]
    def sinkType: Optional[zio.aws.chime.model.MediaPipelineSinkType]
    def sinkArn: Optional[Arn]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def chimeSdkMeetingConfiguration
        : Optional[zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly]
    def getMediaPipelineId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("mediaPipelineId", mediaPipelineId)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.chime.model.MediaPipelineSourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.chime.model.MediaPipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSinkType
        : ZIO[Any, AwsError, zio.aws.chime.model.MediaPipelineSinkType] =
      AwsError.unwrapOptionField("sinkType", sinkType)
    def getSinkArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sinkArn", sinkArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getChimeSdkMeetingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "chimeSdkMeetingConfiguration",
      chimeSdkMeetingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.MediaCapturePipeline
  ) extends zio.aws.chime.model.MediaCapturePipeline.ReadOnly {
    override val mediaPipelineId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineId())
      .map(value => zio.aws.chime.model.primitives.GuidString(value))
    override val sourceType
        : Optional[zio.aws.chime.model.MediaPipelineSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.chime.model.MediaPipelineSourceType.wrap(value))
    override val sourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.chime.model.primitives.Arn(value))
    override val status: Optional[zio.aws.chime.model.MediaPipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.MediaPipelineStatus.wrap(value))
    override val sinkType: Optional[zio.aws.chime.model.MediaPipelineSinkType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sinkType())
        .map(value => zio.aws.chime.model.MediaPipelineSinkType.wrap(value))
    override val sinkArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.sinkArn())
      .map(value => zio.aws.chime.model.primitives.Arn(value))
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val chimeSdkMeetingConfiguration
        : Optional[zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chimeSdkMeetingConfiguration())
        .map(value =>
          zio.aws.chime.model.ChimeSdkMeetingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.MediaCapturePipeline
  ): zio.aws.chime.model.MediaCapturePipeline.ReadOnly = new Wrapper(impl)
}
