package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait MediaPipelineSinkType {
  def unwrap: software.amazon.awssdk.services.chime.model.MediaPipelineSinkType
}
object MediaPipelineSinkType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.MediaPipelineSinkType
  ): zio.aws.chime.model.MediaPipelineSinkType = value match {
    case software.amazon.awssdk.services.chime.model.MediaPipelineSinkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineSinkType.S3_BUCKET =>
      val r = S3Bucket
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.MediaPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineSinkType =
      software.amazon.awssdk.services.chime.model.MediaPipelineSinkType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3Bucket extends zio.aws.chime.model.MediaPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineSinkType =
      software.amazon.awssdk.services.chime.model.MediaPipelineSinkType.S3_BUCKET
  }
}
