package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait MediaPipelineStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.MediaPipelineStatus
}
object MediaPipelineStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.MediaPipelineStatus
  ): zio.aws.chime.model.MediaPipelineStatus = value match {
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.INITIALIZING =>
      val r = Initializing
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.chime.model.MediaPipelineStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Initializing extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.INITIALIZING
  }
  case object InProgress extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.FAILED
  }
  case object Stopping extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.STOPPING
  }
  case object Stopped extends zio.aws.chime.model.MediaPipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MediaPipelineStatus =
      software.amazon.awssdk.services.chime.model.MediaPipelineStatus.STOPPED
  }
}
