package zio.aws.chime.model
import zio.aws.chime.model.primitives.UriType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MediaPlacement(
    audioHostUrl: Optional[UriType] = Optional.Absent,
    audioFallbackUrl: Optional[UriType] = Optional.Absent,
    screenDataUrl: Optional[UriType] = Optional.Absent,
    screenSharingUrl: Optional[UriType] = Optional.Absent,
    screenViewingUrl: Optional[UriType] = Optional.Absent,
    signalingUrl: Optional[UriType] = Optional.Absent,
    turnControlUrl: Optional[UriType] = Optional.Absent,
    eventIngestionUrl: Optional[UriType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.MediaPlacement = {
    import MediaPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.MediaPlacement
      .builder()
      .optionallyWith(
        audioHostUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.audioHostUrl)
      .optionallyWith(
        audioFallbackUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.audioFallbackUrl)
      .optionallyWith(
        screenDataUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.screenDataUrl)
      .optionallyWith(
        screenSharingUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.screenSharingUrl)
      .optionallyWith(
        screenViewingUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.screenViewingUrl)
      .optionallyWith(
        signalingUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.signalingUrl)
      .optionallyWith(
        turnControlUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.turnControlUrl)
      .optionallyWith(
        eventIngestionUrl.map(value => UriType.unwrap(value): java.lang.String)
      )(_.eventIngestionUrl)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.MediaPlacement.ReadOnly =
    zio.aws.chime.model.MediaPlacement.wrap(buildAwsValue())
}
object MediaPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.MediaPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.MediaPlacement =
      zio.aws.chime.model.MediaPlacement(
        audioHostUrl.map(value => value),
        audioFallbackUrl.map(value => value),
        screenDataUrl.map(value => value),
        screenSharingUrl.map(value => value),
        screenViewingUrl.map(value => value),
        signalingUrl.map(value => value),
        turnControlUrl.map(value => value),
        eventIngestionUrl.map(value => value)
      )
    def audioHostUrl: Optional[UriType]
    def audioFallbackUrl: Optional[UriType]
    def screenDataUrl: Optional[UriType]
    def screenSharingUrl: Optional[UriType]
    def screenViewingUrl: Optional[UriType]
    def signalingUrl: Optional[UriType]
    def turnControlUrl: Optional[UriType]
    def eventIngestionUrl: Optional[UriType]
    def getAudioHostUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("audioHostUrl", audioHostUrl)
    def getAudioFallbackUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("audioFallbackUrl", audioFallbackUrl)
    def getScreenDataUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("screenDataUrl", screenDataUrl)
    def getScreenSharingUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("screenSharingUrl", screenSharingUrl)
    def getScreenViewingUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("screenViewingUrl", screenViewingUrl)
    def getSignalingUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("signalingUrl", signalingUrl)
    def getTurnControlUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("turnControlUrl", turnControlUrl)
    def getEventIngestionUrl: ZIO[Any, AwsError, UriType] =
      AwsError.unwrapOptionField("eventIngestionUrl", eventIngestionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.MediaPlacement
  ) extends zio.aws.chime.model.MediaPlacement.ReadOnly {
    override val audioHostUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.audioHostUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val audioFallbackUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.audioFallbackUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val screenDataUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.screenDataUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val screenSharingUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.screenSharingUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val screenViewingUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.screenViewingUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val signalingUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.signalingUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val turnControlUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.turnControlUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
    override val eventIngestionUrl: Optional[UriType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventIngestionUrl())
      .map(value => zio.aws.chime.model.primitives.UriType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.MediaPlacement
  ): zio.aws.chime.model.MediaPlacement.ReadOnly = new Wrapper(impl)
}
