package zio.aws.chime.model
import zio.aws.chime.model.primitives.{ExternalMeetingIdType, GuidString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Meeting(
    meetingId: Optional[GuidString] = Optional.Absent,
    externalMeetingId: Optional[ExternalMeetingIdType] = Optional.Absent,
    mediaPlacement: Optional[zio.aws.chime.model.MediaPlacement] =
      Optional.Absent,
    mediaRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Meeting = {
    import Meeting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Meeting
      .builder()
      .optionallyWith(
        meetingId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.meetingId)
      .optionallyWith(
        externalMeetingId.map(value =>
          ExternalMeetingIdType.unwrap(value): java.lang.String
        )
      )(_.externalMeetingId)
      .optionallyWith(mediaPlacement.map(value => value.buildAwsValue()))(
        _.mediaPlacement
      )
      .optionallyWith(mediaRegion.map(value => value: java.lang.String))(
        _.mediaRegion
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Meeting.ReadOnly =
    zio.aws.chime.model.Meeting.wrap(buildAwsValue())
}
object Meeting {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Meeting] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Meeting = zio.aws.chime.model.Meeting(
      meetingId.map(value => value),
      externalMeetingId.map(value => value),
      mediaPlacement.map(value => value.asEditable),
      mediaRegion.map(value => value)
    )
    def meetingId: Optional[GuidString]
    def externalMeetingId: Optional[ExternalMeetingIdType]
    def mediaPlacement: Optional[zio.aws.chime.model.MediaPlacement.ReadOnly]
    def mediaRegion: Optional[String]
    def getMeetingId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("meetingId", meetingId)
    def getExternalMeetingId: ZIO[Any, AwsError, ExternalMeetingIdType] =
      AwsError.unwrapOptionField("externalMeetingId", externalMeetingId)
    def getMediaPlacement
        : ZIO[Any, AwsError, zio.aws.chime.model.MediaPlacement.ReadOnly] =
      AwsError.unwrapOptionField("mediaPlacement", mediaPlacement)
    def getMediaRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mediaRegion", mediaRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Meeting
  ) extends zio.aws.chime.model.Meeting.ReadOnly {
    override val meetingId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.meetingId())
      .map(value => zio.aws.chime.model.primitives.GuidString(value))
    override val externalMeetingId: Optional[ExternalMeetingIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalMeetingId())
        .map(value =>
          zio.aws.chime.model.primitives.ExternalMeetingIdType(value)
        )
    override val mediaPlacement
        : Optional[zio.aws.chime.model.MediaPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaPlacement())
        .map(value => zio.aws.chime.model.MediaPlacement.wrap(value))
    override val mediaRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaRegion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Meeting
  ): zio.aws.chime.model.Meeting.ReadOnly = new Wrapper(impl)
}
