package zio.aws.chime.model
import zio.aws.chime.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MeetingNotificationConfiguration(
    snsTopicArn: Optional[Arn] = Optional.Absent,
    sqsQueueArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration = {
    import MeetingNotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration
      .builder()
      .optionallyWith(
        snsTopicArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        sqsQueueArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sqsQueueArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly =
    zio.aws.chime.model.MeetingNotificationConfiguration.wrap(buildAwsValue())
}
object MeetingNotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.MeetingNotificationConfiguration =
      zio.aws.chime.model.MeetingNotificationConfiguration(
        snsTopicArn.map(value => value),
        sqsQueueArn.map(value => value)
      )
    def snsTopicArn: Optional[Arn]
    def sqsQueueArn: Optional[Arn]
    def getSnsTopicArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSqsQueueArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sqsQueueArn", sqsQueueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration
  ) extends zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly {
    override val snsTopicArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.chime.model.primitives.Arn(value))
    override val sqsQueueArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.sqsQueueArn())
      .map(value => zio.aws.chime.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration
  ): zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
