package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SensitiveString, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Member(
    memberId: Optional[NonEmptyString] = Optional.Absent,
    memberType: Optional[zio.aws.chime.model.MemberType] = Optional.Absent,
    email: Optional[SensitiveString] = Optional.Absent,
    fullName: Optional[SensitiveString] = Optional.Absent,
    accountId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Member
      .builder()
      .optionallyWith(
        memberId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.memberId)
      .optionallyWith(memberType.map(value => value.unwrap))(_.memberType)
      .optionallyWith(
        email.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        fullName.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.fullName)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Member.ReadOnly =
    zio.aws.chime.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Member] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Member = zio.aws.chime.model.Member(
      memberId.map(value => value),
      memberType.map(value => value),
      email.map(value => value),
      fullName.map(value => value),
      accountId.map(value => value)
    )
    def memberId: Optional[NonEmptyString]
    def memberType: Optional[zio.aws.chime.model.MemberType]
    def email: Optional[SensitiveString]
    def fullName: Optional[SensitiveString]
    def accountId: Optional[NonEmptyString]
    def getMemberId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getMemberType: ZIO[Any, AwsError, zio.aws.chime.model.MemberType] =
      AwsError.unwrapOptionField("memberType", memberType)
    def getEmail: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("email", email)
    def getFullName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("fullName", fullName)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Member
  ) extends zio.aws.chime.model.Member.ReadOnly {
    override val memberId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val memberType: Optional[zio.aws.chime.model.MemberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberType())
        .map(value => zio.aws.chime.model.MemberType.wrap(value))
    override val email: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val fullName: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.fullName())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Member
  ): zio.aws.chime.model.Member.ReadOnly = new Wrapper(impl)
}
