package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait MemberType {
  def unwrap: software.amazon.awssdk.services.chime.model.MemberType
}
object MemberType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.MemberType
  ): zio.aws.chime.model.MemberType = value match {
    case software.amazon.awssdk.services.chime.model.MemberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.MemberType.USER =>
      val r = User
      r
    case software.amazon.awssdk.services.chime.model.MemberType.BOT =>
      val r = Bot
      r
    case software.amazon.awssdk.services.chime.model.MemberType.WEBHOOK =>
      val r = Webhook
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.MemberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MemberType =
      software.amazon.awssdk.services.chime.model.MemberType.UNKNOWN_TO_SDK_VERSION
  }
  case object User extends zio.aws.chime.model.MemberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MemberType =
      software.amazon.awssdk.services.chime.model.MemberType.USER
  }
  case object Bot extends zio.aws.chime.model.MemberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MemberType =
      software.amazon.awssdk.services.chime.model.MemberType.BOT
  }
  case object Webhook extends zio.aws.chime.model.MemberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.MemberType =
      software.amazon.awssdk.services.chime.model.MemberType.WEBHOOK
  }
}
