package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MembershipItem(
    memberId: Optional[NonEmptyString] = Optional.Absent,
    role: Optional[zio.aws.chime.model.RoomMembershipRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.MembershipItem = {
    import MembershipItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.MembershipItem
      .builder()
      .optionallyWith(
        memberId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.memberId)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.MembershipItem.ReadOnly =
    zio.aws.chime.model.MembershipItem.wrap(buildAwsValue())
}
object MembershipItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.MembershipItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.MembershipItem = zio.aws.chime.model
      .MembershipItem(memberId.map(value => value), role.map(value => value))
    def memberId: Optional[NonEmptyString]
    def role: Optional[zio.aws.chime.model.RoomMembershipRole]
    def getMemberId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getRole: ZIO[Any, AwsError, zio.aws.chime.model.RoomMembershipRole] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.MembershipItem
  ) extends zio.aws.chime.model.MembershipItem.ReadOnly {
    override val memberId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val role: Optional[zio.aws.chime.model.RoomMembershipRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.chime.model.RoomMembershipRole.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.MembershipItem
  ): zio.aws.chime.model.MembershipItem.ReadOnly = new Wrapper(impl)
}
