package zio.aws.chime.model
import zio.aws.chime.model.primitives.UrlType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessagingSessionEndpoint(
    url: Optional[UrlType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.MessagingSessionEndpoint = {
    import MessagingSessionEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.MessagingSessionEndpoint
      .builder()
      .optionallyWith(
        url.map(value => UrlType.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.MessagingSessionEndpoint.ReadOnly =
    zio.aws.chime.model.MessagingSessionEndpoint.wrap(buildAwsValue())
}
object MessagingSessionEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.MessagingSessionEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.MessagingSessionEndpoint =
      zio.aws.chime.model.MessagingSessionEndpoint(url.map(value => value))
    def url: Optional[UrlType]
    def getUrl: ZIO[Any, AwsError, UrlType] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.MessagingSessionEndpoint
  ) extends zio.aws.chime.model.MessagingSessionEndpoint.ReadOnly {
    override val url: Optional[UrlType] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.chime.model.primitives.UrlType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.MessagingSessionEndpoint
  ): zio.aws.chime.model.MessagingSessionEndpoint.ReadOnly = new Wrapper(impl)
}
