package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait NumberSelectionBehavior {
  def unwrap
      : software.amazon.awssdk.services.chime.model.NumberSelectionBehavior
}
object NumberSelectionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.NumberSelectionBehavior
  ): zio.aws.chime.model.NumberSelectionBehavior = value match {
    case software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.PREFER_STICKY =>
      val r = PreferSticky
      r
    case software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.AVOID_STICKY =>
      val r = AvoidSticky
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.NumberSelectionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.NumberSelectionBehavior =
      software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object PreferSticky extends zio.aws.chime.model.NumberSelectionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.NumberSelectionBehavior =
      software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.PREFER_STICKY
  }
  case object AvoidSticky extends zio.aws.chime.model.NumberSelectionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.NumberSelectionBehavior =
      software.amazon.awssdk.services.chime.model.NumberSelectionBehavior.AVOID_STICKY
  }
}
