package zio.aws.chime.model
import zio.aws.chime.model.primitives.E164PhoneNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrderedPhoneNumber(
    e164PhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    status: Optional[zio.aws.chime.model.OrderedPhoneNumberStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.OrderedPhoneNumber = {
    import OrderedPhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.OrderedPhoneNumber
      .builder()
      .optionallyWith(
        e164PhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.e164PhoneNumber)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.OrderedPhoneNumber.ReadOnly =
    zio.aws.chime.model.OrderedPhoneNumber.wrap(buildAwsValue())
}
object OrderedPhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.OrderedPhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.OrderedPhoneNumber =
      zio.aws.chime.model.OrderedPhoneNumber(
        e164PhoneNumber.map(value => value),
        status.map(value => value)
      )
    def e164PhoneNumber: Optional[E164PhoneNumber]
    def status: Optional[zio.aws.chime.model.OrderedPhoneNumberStatus]
    def getE164PhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("e164PhoneNumber", e164PhoneNumber)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.OrderedPhoneNumberStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.OrderedPhoneNumber
  ) extends zio.aws.chime.model.OrderedPhoneNumber.ReadOnly {
    override val e164PhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.e164PhoneNumber())
        .map(value => zio.aws.chime.model.primitives.E164PhoneNumber(value))
    override val status
        : Optional[zio.aws.chime.model.OrderedPhoneNumberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.OrderedPhoneNumberStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.OrderedPhoneNumber
  ): zio.aws.chime.model.OrderedPhoneNumber.ReadOnly = new Wrapper(impl)
}
