package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait OrderedPhoneNumberStatus {
  def unwrap
      : software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus
}
object OrderedPhoneNumberStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus
  ): zio.aws.chime.model.OrderedPhoneNumberStatus = value match {
    case software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.ACQUIRED =>
      val r = Acquired
      r
    case software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.OrderedPhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Processing extends zio.aws.chime.model.OrderedPhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.PROCESSING
  }
  case object Acquired extends zio.aws.chime.model.OrderedPhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.ACQUIRED
  }
  case object Failed extends zio.aws.chime.model.OrderedPhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus.FAILED
  }
}
