package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Origination(
    routes: Optional[Iterable[zio.aws.chime.model.OriginationRoute]] =
      Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.Origination = {
    import Origination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Origination
      .builder()
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Origination.ReadOnly =
    zio.aws.chime.model.Origination.wrap(buildAwsValue())
}
object Origination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Origination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Origination =
      zio.aws.chime.model.Origination(
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disabled.map(value => value)
      )
    def routes: Optional[List[zio.aws.chime.model.OriginationRoute.ReadOnly]]
    def disabled: Optional[Boolean]
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.chime.model.OriginationRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Origination
  ) extends zio.aws.chime.model.Origination.ReadOnly {
    override val routes
        : Optional[List[zio.aws.chime.model.OriginationRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.OriginationRoute.wrap(item)
          }.toList
        )
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Origination
  ): zio.aws.chime.model.Origination.ReadOnly = new Wrapper(impl)
}
