package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait OriginationRouteProtocol {
  def unwrap
      : software.amazon.awssdk.services.chime.model.OriginationRouteProtocol
}
object OriginationRouteProtocol {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.OriginationRouteProtocol
  ): zio.aws.chime.model.OriginationRouteProtocol = value match {
    case software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.OriginationRouteProtocol {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OriginationRouteProtocol =
      software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.chime.model.OriginationRouteProtocol {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OriginationRouteProtocol =
      software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.TCP
  }
  case object UDP extends zio.aws.chime.model.OriginationRouteProtocol {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.OriginationRouteProtocol =
      software.amazon.awssdk.services.chime.model.OriginationRouteProtocol.UDP
  }
}
