package zio.aws.chime.model
import zio.aws.chime.model.primitives.E164PhoneNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Participant(
    phoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    proxyPhoneNumber: Optional[E164PhoneNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.Participant = {
    import Participant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Participant
      .builder()
      .optionallyWith(
        phoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.phoneNumber)
      .optionallyWith(
        proxyPhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.proxyPhoneNumber)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Participant.ReadOnly =
    zio.aws.chime.model.Participant.wrap(buildAwsValue())
}
object Participant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Participant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Participant =
      zio.aws.chime.model.Participant(
        phoneNumber.map(value => value),
        proxyPhoneNumber.map(value => value)
      )
    def phoneNumber: Optional[E164PhoneNumber]
    def proxyPhoneNumber: Optional[E164PhoneNumber]
    def getPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getProxyPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("proxyPhoneNumber", proxyPhoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Participant
  ) extends zio.aws.chime.model.Participant.ReadOnly {
    override val phoneNumber: Optional[E164PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.chime.model.primitives.E164PhoneNumber(value))
    override val proxyPhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyPhoneNumber())
        .map(value => zio.aws.chime.model.primitives.E164PhoneNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Participant
  ): zio.aws.chime.model.Participant.ReadOnly = new Wrapper(impl)
}
