package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Iso8601Timestamp,
  CallingName,
  Alpha2CountryCode,
  E164PhoneNumber
}
import scala.jdk.CollectionConverters._
final case class PhoneNumber(
    phoneNumberId: Optional[String] = Optional.Absent,
    e164PhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    country: Optional[Alpha2CountryCode] = Optional.Absent,
    `type`: Optional[zio.aws.chime.model.PhoneNumberType] = Optional.Absent,
    productType: Optional[zio.aws.chime.model.PhoneNumberProductType] =
      Optional.Absent,
    status: Optional[zio.aws.chime.model.PhoneNumberStatus] = Optional.Absent,
    capabilities: Optional[zio.aws.chime.model.PhoneNumberCapabilities] =
      Optional.Absent,
    associations: Optional[
      Iterable[zio.aws.chime.model.PhoneNumberAssociation]
    ] = Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent,
    callingNameStatus: Optional[zio.aws.chime.model.CallingNameStatus] =
      Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    deletionTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PhoneNumber = {
    import PhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PhoneNumber
      .builder()
      .optionallyWith(phoneNumberId.map(value => value: java.lang.String))(
        _.phoneNumberId
      )
      .optionallyWith(
        e164PhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.e164PhoneNumber)
      .optionallyWith(
        country.map(value => Alpha2CountryCode.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .optionallyWith(callingNameStatus.map(value => value.unwrap))(
        _.callingNameStatus
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        deletionTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.deletionTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PhoneNumber.ReadOnly =
    zio.aws.chime.model.PhoneNumber.wrap(buildAwsValue())
}
object PhoneNumber {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.PhoneNumber] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PhoneNumber =
      zio.aws.chime.model.PhoneNumber(
        phoneNumberId.map(value => value),
        e164PhoneNumber.map(value => value),
        country.map(value => value),
        `type`.map(value => value),
        productType.map(value => value),
        status.map(value => value),
        capabilities.map(value => value.asEditable),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        callingName.map(value => value),
        callingNameStatus.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        deletionTimestamp.map(value => value)
      )
    def phoneNumberId: Optional[String]
    def e164PhoneNumber: Optional[E164PhoneNumber]
    def country: Optional[Alpha2CountryCode]
    def `type`: Optional[zio.aws.chime.model.PhoneNumberType]
    def productType: Optional[zio.aws.chime.model.PhoneNumberProductType]
    def status: Optional[zio.aws.chime.model.PhoneNumberStatus]
    def capabilities
        : Optional[zio.aws.chime.model.PhoneNumberCapabilities.ReadOnly]
    def associations
        : Optional[List[zio.aws.chime.model.PhoneNumberAssociation.ReadOnly]]
    def callingName: Optional[CallingName]
    def callingNameStatus: Optional[zio.aws.chime.model.CallingNameStatus]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def deletionTimestamp: Optional[Iso8601Timestamp]
    def getPhoneNumberId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getE164PhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("e164PhoneNumber", e164PhoneNumber)
    def getCountry: ZIO[Any, AwsError, Alpha2CountryCode] =
      AwsError.unwrapOptionField("country", country)
    def getType: ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberType] =
      AwsError.unwrapOptionField("type", `type`)
    def getProductType
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberProductType] =
      AwsError.unwrapOptionField("productType", productType)
    def getStatus: ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.PhoneNumberCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.chime.model.PhoneNumberAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
    def getCallingNameStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.CallingNameStatus] =
      AwsError.unwrapOptionField("callingNameStatus", callingNameStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getDeletionTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("deletionTimestamp", deletionTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumber
  ) extends zio.aws.chime.model.PhoneNumber.ReadOnly {
    override val phoneNumberId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => value: String)
    override val e164PhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.e164PhoneNumber())
        .map(value => zio.aws.chime.model.primitives.E164PhoneNumber(value))
    override val country: Optional[Alpha2CountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => zio.aws.chime.model.primitives.Alpha2CountryCode(value))
    override val `type`: Optional[zio.aws.chime.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.chime.model.PhoneNumberType.wrap(value))
    override val productType
        : Optional[zio.aws.chime.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value => zio.aws.chime.model.PhoneNumberProductType.wrap(value))
    override val status: Optional[zio.aws.chime.model.PhoneNumberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.PhoneNumberStatus.wrap(value))
    override val capabilities
        : Optional[zio.aws.chime.model.PhoneNumberCapabilities.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value => zio.aws.chime.model.PhoneNumberCapabilities.wrap(value))
    override val associations
        : Optional[List[zio.aws.chime.model.PhoneNumberAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.PhoneNumberAssociation.wrap(item)
          }.toList
        )
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chime.model.primitives.CallingName(value))
    override val callingNameStatus
        : Optional[zio.aws.chime.model.CallingNameStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callingNameStatus())
        .map(value => zio.aws.chime.model.CallingNameStatus.wrap(value))
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val deletionTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumber
  ): zio.aws.chime.model.PhoneNumber.ReadOnly = new Wrapper(impl)
}
