package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.Iso8601Timestamp
import scala.jdk.CollectionConverters._
final case class PhoneNumberAssociation(
    value: Optional[String] = Optional.Absent,
    name: Optional[zio.aws.chime.model.PhoneNumberAssociationName] =
      Optional.Absent,
    associatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PhoneNumberAssociation = {
    import PhoneNumberAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PhoneNumberAssociation
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        associatedTimestamp.map(value =>
          Iso8601Timestamp.unwrap(value): Instant
        )
      )(_.associatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PhoneNumberAssociation.ReadOnly =
    zio.aws.chime.model.PhoneNumberAssociation.wrap(buildAwsValue())
}
object PhoneNumberAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PhoneNumberAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PhoneNumberAssociation =
      zio.aws.chime.model.PhoneNumberAssociation(
        value.map(value => value),
        name.map(value => value),
        associatedTimestamp.map(value => value)
      )
    def value: Optional[String]
    def name: Optional[zio.aws.chime.model.PhoneNumberAssociationName]
    def associatedTimestamp: Optional[Iso8601Timestamp]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberAssociationName] =
      AwsError.unwrapOptionField("name", name)
    def getAssociatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("associatedTimestamp", associatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberAssociation
  ) extends zio.aws.chime.model.PhoneNumberAssociation.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val name
        : Optional[zio.aws.chime.model.PhoneNumberAssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.chime.model.PhoneNumberAssociationName.wrap(value)
        )
    override val associatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberAssociation
  ): zio.aws.chime.model.PhoneNumberAssociation.ReadOnly = new Wrapper(impl)
}
