package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberAssociationName {
  def unwrap
      : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName
}
object PhoneNumberAssociationName {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName
  ): zio.aws.chime.model.PhoneNumberAssociationName = value match {
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.ACCOUNT_ID =>
      val r = AccountId
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.USER_ID =>
      val r = UserId
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.VOICE_CONNECTOR_ID =>
      val r = VoiceConnectorId
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.VOICE_CONNECTOR_GROUP_ID =>
      val r = VoiceConnectorGroupId
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.SIP_RULE_ID =>
      val r = SipRuleId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.ACCOUNT_ID
  }
  case object UserId extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.USER_ID
  }
  case object VoiceConnectorId
      extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.VOICE_CONNECTOR_ID
  }
  case object VoiceConnectorGroupId
      extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.VOICE_CONNECTOR_GROUP_ID
  }
  case object SipRuleId extends zio.aws.chime.model.PhoneNumberAssociationName {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName =
      software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName.SIP_RULE_ID
  }
}
