package zio.aws.chime.model
import zio.aws.chime.model.primitives.Alpha2CountryCode
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PhoneNumberCountry(
    countryCode: Optional[Alpha2CountryCode] = Optional.Absent,
    supportedPhoneNumberTypes: Optional[
      Iterable[zio.aws.chime.model.PhoneNumberType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PhoneNumberCountry = {
    import PhoneNumberCountry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PhoneNumberCountry
      .builder()
      .optionallyWith(
        countryCode.map(value =>
          Alpha2CountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        supportedPhoneNumberTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedPhoneNumberTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PhoneNumberCountry.ReadOnly =
    zio.aws.chime.model.PhoneNumberCountry.wrap(buildAwsValue())
}
object PhoneNumberCountry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PhoneNumberCountry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PhoneNumberCountry =
      zio.aws.chime.model.PhoneNumberCountry(
        countryCode.map(value => value),
        supportedPhoneNumberTypes.map(value => value)
      )
    def countryCode: Optional[Alpha2CountryCode]
    def supportedPhoneNumberTypes
        : Optional[List[zio.aws.chime.model.PhoneNumberType]]
    def getCountryCode: ZIO[Any, AwsError, Alpha2CountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getSupportedPhoneNumberTypes
        : ZIO[Any, AwsError, List[zio.aws.chime.model.PhoneNumberType]] =
      AwsError.unwrapOptionField(
        "supportedPhoneNumberTypes",
        supportedPhoneNumberTypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberCountry
  ) extends zio.aws.chime.model.PhoneNumberCountry.ReadOnly {
    override val countryCode: Optional[Alpha2CountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countryCode())
        .map(value => zio.aws.chime.model.primitives.Alpha2CountryCode(value))
    override val supportedPhoneNumberTypes
        : Optional[List[zio.aws.chime.model.PhoneNumberType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedPhoneNumberTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.PhoneNumberType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberCountry
  ): zio.aws.chime.model.PhoneNumberCountry.ReadOnly = new Wrapper(impl)
}
