package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PhoneNumberError(
    phoneNumberId: Optional[NonEmptyString] = Optional.Absent,
    errorCode: Optional[zio.aws.chime.model.ErrorCode] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PhoneNumberError = {
    import PhoneNumberError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PhoneNumberError
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PhoneNumberError.ReadOnly =
    zio.aws.chime.model.PhoneNumberError.wrap(buildAwsValue())
}
object PhoneNumberError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PhoneNumberError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PhoneNumberError =
      zio.aws.chime.model.PhoneNumberError(
        phoneNumberId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def phoneNumberId: Optional[NonEmptyString]
    def errorCode: Optional[zio.aws.chime.model.ErrorCode]
    def errorMessage: Optional[String]
    def getPhoneNumberId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.chime.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberError
  ) extends zio.aws.chime.model.PhoneNumberError.ReadOnly {
    override val phoneNumberId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val errorCode: Optional[zio.aws.chime.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.chime.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberError
  ): zio.aws.chime.model.PhoneNumberError.ReadOnly = new Wrapper(impl)
}
