package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Iso8601Timestamp, GuidString}
import scala.jdk.CollectionConverters._
final case class PhoneNumberOrder(
    phoneNumberOrderId: Optional[GuidString] = Optional.Absent,
    productType: Optional[zio.aws.chime.model.PhoneNumberProductType] =
      Optional.Absent,
    status: Optional[zio.aws.chime.model.PhoneNumberOrderStatus] =
      Optional.Absent,
    orderedPhoneNumbers: Optional[
      Iterable[zio.aws.chime.model.OrderedPhoneNumber]
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PhoneNumberOrder = {
    import PhoneNumberOrder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PhoneNumberOrder
      .builder()
      .optionallyWith(
        phoneNumberOrderId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.phoneNumberOrderId)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        orderedPhoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderedPhoneNumbers)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PhoneNumberOrder.ReadOnly =
    zio.aws.chime.model.PhoneNumberOrder.wrap(buildAwsValue())
}
object PhoneNumberOrder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PhoneNumberOrder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PhoneNumberOrder =
      zio.aws.chime.model.PhoneNumberOrder(
        phoneNumberOrderId.map(value => value),
        productType.map(value => value),
        status.map(value => value),
        orderedPhoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def phoneNumberOrderId: Optional[GuidString]
    def productType: Optional[zio.aws.chime.model.PhoneNumberProductType]
    def status: Optional[zio.aws.chime.model.PhoneNumberOrderStatus]
    def orderedPhoneNumbers
        : Optional[List[zio.aws.chime.model.OrderedPhoneNumber.ReadOnly]]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getPhoneNumberOrderId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("phoneNumberOrderId", phoneNumberOrderId)
    def getProductType
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberProductType] =
      AwsError.unwrapOptionField("productType", productType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberOrderStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOrderedPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.chime.model.OrderedPhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("orderedPhoneNumbers", orderedPhoneNumbers)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberOrder
  ) extends zio.aws.chime.model.PhoneNumberOrder.ReadOnly {
    override val phoneNumberOrderId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrderId())
        .map(value => zio.aws.chime.model.primitives.GuidString(value))
    override val productType
        : Optional[zio.aws.chime.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value => zio.aws.chime.model.PhoneNumberProductType.wrap(value))
    override val status: Optional[zio.aws.chime.model.PhoneNumberOrderStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chime.model.PhoneNumberOrderStatus.wrap(value))
    override val orderedPhoneNumbers
        : Optional[List[zio.aws.chime.model.OrderedPhoneNumber.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderedPhoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.OrderedPhoneNumber.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PhoneNumberOrder
  ): zio.aws.chime.model.PhoneNumberOrder.ReadOnly = new Wrapper(impl)
}
