package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberOrderStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus
}
object PhoneNumberOrderStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus
  ): zio.aws.chime.model.PhoneNumberOrderStatus = value match {
    case software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.PARTIAL =>
      val r = Partial
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.PhoneNumberOrderStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Processing extends zio.aws.chime.model.PhoneNumberOrderStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.PROCESSING
  }
  case object Successful extends zio.aws.chime.model.PhoneNumberOrderStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.SUCCESSFUL
  }
  case object Failed extends zio.aws.chime.model.PhoneNumberOrderStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.FAILED
  }
  case object Partial extends zio.aws.chime.model.PhoneNumberOrderStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus.PARTIAL
  }
}
