package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberProductType {
  def unwrap: software.amazon.awssdk.services.chime.model.PhoneNumberProductType
}
object PhoneNumberProductType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.PhoneNumberProductType
  ): zio.aws.chime.model.PhoneNumberProductType = value match {
    case software.amazon.awssdk.services.chime.model.PhoneNumberProductType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberProductType.BUSINESS_CALLING =>
      val r = BusinessCalling
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberProductType.VOICE_CONNECTOR =>
      val r = VoiceConnector
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberProductType.SIP_MEDIA_APPLICATION_DIAL_IN =>
      val r = SipMediaApplicationDialIn
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.PhoneNumberProductType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberProductType =
      software.amazon.awssdk.services.chime.model.PhoneNumberProductType.UNKNOWN_TO_SDK_VERSION
  }
  case object BusinessCalling
      extends zio.aws.chime.model.PhoneNumberProductType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberProductType =
      software.amazon.awssdk.services.chime.model.PhoneNumberProductType.BUSINESS_CALLING
  }
  case object VoiceConnector
      extends zio.aws.chime.model.PhoneNumberProductType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberProductType =
      software.amazon.awssdk.services.chime.model.PhoneNumberProductType.VOICE_CONNECTOR
  }
  case object SipMediaApplicationDialIn
      extends zio.aws.chime.model.PhoneNumberProductType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberProductType =
      software.amazon.awssdk.services.chime.model.PhoneNumberProductType.SIP_MEDIA_APPLICATION_DIAL_IN
  }
}
